library ieee;
--library gold_lib;   --UNCOMMENT if you're using a GOLD model
use ieee.std_logic_1164.all;
--use gold_lib.all;   --UNCOMMENT if you're using a GOLD model

entity tb_top_level is
generic (Period : Time := 4 ns);
end tb_top_level;

architecture TEST of tb_top_level is

  function INT_TO_STD_LOGIC( X: INTEGER; NumBits: INTEGER )
     return STD_LOGIC_VECTOR is
    variable RES : STD_LOGIC_VECTOR(NumBits-1 downto 0);
    variable tmp : INTEGER;
  begin
    tmp := X;
    for i in 0 to NumBits-1 loop
      if (tmp mod 2)=1 then
        res(i) := '1';
      else
        res(i) := '0';
      end if;
      tmp := tmp/2;
    end loop;
    return res;
  end;

  component top_level
    PORT(
         CLK : IN STD_LOGIC;
         DATA_IN : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
         ENABLE1 : IN STD_LOGIC;
         LCD_CLK : IN STD_LOGIC;
         LOAD : IN STD_LOGIC;
         OPCODE_IN : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
         nRST : IN STD_LOGIC;
         BUSY_OUT1 : OUT STD_LOGIC;
         PIXEL : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
         ROW : OUT STD_LOGIC;
         busy_out : OUT std_logic
    );
  end component;

-- Insert signals Declarations here
  signal CLK : STD_LOGIC;
  signal DATA_IN : STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal ENABLE1 : STD_LOGIC;
  signal LCD_CLK : STD_LOGIC;
  signal LOAD : STD_LOGIC;
  signal OPCODE_IN : STD_LOGIC_VECTOR (3 DOWNTO 0);
  signal nRST : STD_LOGIC;
  signal BUSY_OUT1 : STD_LOGIC;
  signal PIXEL : STD_LOGIC_VECTOR (7 DOWNTO 0);
  signal ROW : STD_LOGIC;
  signal busy_out : std_logic;

-- signal <name> : <type>;

begin

CLKGEN: process
  variable CLK_tmp: std_logic := '0';
begin
  CLK_tmp := not CLK_tmp;
  CLK <= CLK_tmp;
  wait for Period/2;
end process;

LCDCLKGEN: process
  variable LCDCLK_tmp: std_logic := '0';
  variable LCD_Period: time := 250 ns;
begin
  LCDCLK_tmp := not LCDCLK_tmp;
  LCD_CLK <= LCDCLK_tmp;
  wait for LCD_Period/2;
end process;

  DUT: top_level port map(
                CLK => CLK,
                DATA_IN => DATA_IN,
                ENABLE1 => ENABLE1,
                LCD_CLK => LCD_CLK,
                LOAD => LOAD,
                OPCODE_IN => OPCODE_IN,
                nRST => nRST,
                BUSY_OUT1 => BUSY_OUT1,
                PIXEL => PIXEL,
                ROW => ROW,
                busy_out => busy_out
                );

--   GOLD: <GOLD_NAME> port map(<put mappings here>);

process

  begin

-- Insert TEST BENCH Code Here

    ENABLE1 <= '1';

    LOAD <= '0';
    nRST <= '0';
    OPCODE_IN <= "0000";
    DATA_IN <= x"00000000";

    wait for 8 ns;

    nRST <= '1';
--xfov 1.000000 
    OPCODE_IN <= "0011";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--yfov 1.000000 
    OPCODE_IN <= "0100";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--color 128
    OPCODE_IN <= "0111";
    DATA_IN <= "00000000000000000000000010000000";
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    
--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.996195 0.000000 -0.087156 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.087156 0.000000 0.996195 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000001111111100000110";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111111110100110110001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000001011001001111";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001111111100000110";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.984808 0.000000 -0.173648 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.173648 0.000000 0.984808 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000001111110000011100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111111101001110001100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000010110001110100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001111110000011100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.939693 0.000000 -0.342020 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.342020 0.000000 0.939693 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000001111000010001111";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111111010100001110010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000101011110001110";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001111000010001111";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.906308 0.000000 -0.422618 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.422618 0.000000 0.906308 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000001110100000000011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111111001001111010000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000110110000110000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001110100000000011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.866025 0.000000 -0.500000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.500000 0.000000 0.866025 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000001101110110110011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111111000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001101110110110011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.819152 0.000000 -0.573576 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.573576 0.000000 0.819152 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000001101000110110011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110110110100101011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001001001011010101";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001101000110110011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.766044 0.000000 -0.642788 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.642788 0.000000 0.766044 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000001100010000011011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110101101101110011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001010010010001101";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001100010000011011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.707107 0.000000 -0.707107 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.707107 0.000000 0.707107 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000001011010100000100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110100101011111100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001011010100000100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001011010100000100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.642788 0.000000 -0.766044 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.766044 0.000000 0.642788 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000001010010010001101";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110011101111100101";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001100010000011011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001010010010001101";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.573576 0.000000 -0.819152 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.819152 0.000000 0.573576 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000001001001011010101";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110010111001001101";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001101000110110011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001001001011010101";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.500000 0.000000 -0.866025 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.866025 0.000000 0.500000 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000000111111111111111";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110010001001001101";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001101110110110011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000111111111111111";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.422618 0.000000 -0.906308 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.906308 0.000000 0.422618 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000000110110000110000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110001011111111101";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001110100000000011";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000110110000110000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.342020 0.000000 -0.939693 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.939693 0.000000 0.342020 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000000101011110001110";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000111101110001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001111000010001111";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000101011110001110";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.258819 0.000000 -0.965926 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.965926 0.000000 0.258819 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000000100001001000001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000100010111010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001111011101000110";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000100001001000001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.173648 0.000000 -0.984808 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.984808 0.000000 0.173648 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000000010110001110100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000001111100100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001111110000011100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000010110001110100";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--clr 
    OPCODE_IN <= "1000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--rstmat 
    OPCODE_IN <= "0010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 1.000000 0.000000 0.000000 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.000000 0.000000 1.000000 4.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000001000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--mulmat 0.087156 0.000000 -0.996195 0.000000 
--       0.000000 1.000000 0.000000 0.000000 
--       0.996195 0.000000 0.087156 0.000000 
--       0.000000 0.000000 0.000000 1.000000 
    OPCODE_IN <= "0001";
    DATA_IN <= "00000000000000000001011001001111";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000011111010";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000001111111100000110";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000001011001001111";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000000000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     -1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 -1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d 1.000000 1.000000 1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 -1.000000 
--     1.000000 -1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 -1.000000 1.000000 
--     1.000000 -1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 -1.000000 
--     1.000000 1.000000 -1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--ln3d -1.000000 1.000000 1.000000 
--     1.000000 1.000000 1.000000 
    OPCODE_IN <= "0110";
    DATA_IN <= "11111111111111110000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';
    DATA_IN <= "00000000000000010000000000000000";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

--flip 
    OPCODE_IN <= "1001";
    while BUSY_OUT1 = '1' loop
      wait for 12 ns;
    end loop;
    wait for 12 ns;
    LOAD <= '1';
    wait for 12 ns;
    LOAD <= '0';

    wait for 1000000 ns;

  end process;
end TEST;
