LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

entity SRAM_Control is
  port(
    CLK : in std_logic;
    nRST : in std_logic;
    
-- Controller Interface   
    SWAP : in std_logic;
    BUSY : out std_logic;
    
-- To Screen_Buffer interface
    SAddress : in std_logic_vector(15 downto 0);
    SData : in std_logic_vector(15 downto 0);
    SDataOut : out std_logic_vector(15 downto 0);
    Store : in std_logic;
    Smemwait : out std_logic;
    SLoad : in std_logic;
    
-- To LCD Driver
    LAddress: in std_logic_vector(15 downto 0);
    LData : out std_logic_vector(15 downto 0);
    donedraw : in std_logic;
    
    
-- To SRAMs
    nOutputEnable1 : out  std_logic;
    nWriteEnable1  : out  std_logic;
    nChipEnable1   : out  std_logic;
    DataBus1       : inout  std_logic_vector(15 downto 0);
    Address1       : out  std_logic_vector(15 downto 0);
    DumpSignal1    : out  std_logic;
    memWait1       : in std_logic; 
    
    nOutputEnable2 : out std_logic;
    nWriteEnable2  : out std_logic;
    nChipEnable2   : out std_logic;
    DataBus2       : inout  std_logic_vector(15 downto 0);
    Address2       : out std_logic_vector(15 downto 0);
    DumpSignal2    : out std_logic;
    memWait2       : in  std_logic);
end SRAM_Control;

architecture control of SRAM_Control is
  type statetype is (IDLE, SWAP_STATE, WAITING);
  signal state, nextstate : statetype;
  signal current_buffer, next_buffer : std_logic;
begin  -- buffer
    Dostate: process (CLK, nRST)
    begin  -- process Dostate
      if nRST = '0' then                  -- asynchronous reset (active low)
        state <= IDLE;
        current_buffer <= '0';
      elsif CLK'event and CLK = '1' then  -- rising clock edge
        state <= nextstate;
        current_buffer <= next_buffer;
      end if;
  end process Dostate;
  
  State_Logic: process(state, CLK, nRST, current_buffer, swap, donedraw)
  begin
    case state is
      when IDLE =>
        BUSY <= '0';
        next_buffer <= current_buffer;
        if SWAP = '1' then
          nextstate <= SWAP_STATE;
        else
          nextstate <= IDLE;
        end if;
      when SWAP_STATE =>
        BUSY <= '1';
        if donedraw = '1' then
          next_buffer <= not current_buffer;
          nextstate <= WAITING;
        else
          nextstate <= SWAP_STATE;
          next_buffer <= current_buffer;
        end if;
      when WAITING =>
        BUSY <= '1';
        if SWAP = '0' then
          nextstate <= IDLE;
        else
          nextstate <= WAITING;
        end if;
        next_buffer <= current_buffer;
      when others =>
        nextstate <= IDLE;
        BUSY <= '0';
        next_buffer <= current_buffer;
      end case;
  end process State_Logic;
  
  Address2 <= LAddress when current_buffer = '1' else SAddress;
  Address1 <= LAddress when current_buffer = '0' else SAddress;
  LData <= DataBus2 when current_buffer = '1' else DataBus1;
  Smemwait <= memWait1 when current_buffer = '1' else memWait2;
  --DataBus1 <= SData when current_buffer = '1' and SLoad = '0';
  --DataBus2 <= SData when current_buffer = '0' and SLoad = '0';

  
  DataBus1 <= SData when current_buffer = '1' and SLoad = '0' else "ZZZZZZZZZZZZZZZZ";
  DataBus2 <= SData when current_buffer = '0' and SLoad = '0' else "ZZZZZZZZZZZZZZZZ";

  --DataBus1 <= SData when current_buffer = '1' and SLoad = '0' else "XXXXXXXXXXXXXXXX";
  --DataBus2 <= SData when current_buffer = '0' and SLoad = '0' else "XXXXXXXXXXXXXXXX";
  
  
  
  
  --SData <= DataBus1 when (current_buffer = '1' and Sload = '1');
  --SData <= DataBus2 when (current_buffer = '0' and Sload = '1');
 -- SData <= "ZZZZZZZZZZZZZZZZ" when Sload = '0';
  SDataOut <= DataBus1 when current_buffer = '1' else DataBus2;
  nChipEnable1 <= '0';
  nChipEnable2 <= '0';
  DumpSignal1 <= '0';
  DumpSignal2 <= '0';
  nWriteEnable1 <= not Store when current_buffer = '1' else '1';
  nWriteEnable2 <= not Store when current_buffer = '0' else '1';
  nOutputEnable1 <= '0' when current_buffer = '0' else not SLoad;
  nOutputEnable2 <= '0' when current_buffer = '1' else not SLoad;
  
  
end control;
