-- VHDL Entity gpu_lib.gpu.symbol
--
-- Created:
--          by - mg34.other (srge09.ecn.purdue.edu)
--          at - 00:58:34 04/25/05
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2004.1b (Build 11)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY gpu IS
   PORT( 
      CLK       : IN     STD_LOGIC;
      DATA_IN   : IN     STD_LOGIC_VECTOR (31 DOWNTO 0);
      ENABLE1   : IN     STD_LOGIC;
      LCD_CLK   : IN     STD_LOGIC;
      LOAD      : IN     STD_LOGIC;
      OPCODE_IN : IN     STD_LOGIC_VECTOR (3 DOWNTO 0);
      nRST      : IN     STD_LOGIC;
      BUSY_OUT1 : OUT    STD_LOGIC;
      PIXEL     : OUT    STD_LOGIC_VECTOR (7 DOWNTO 0);
      ROW       : OUT    STD_LOGIC;
      busy_out  : OUT    std_logic;
      
      memWait1       : in std_logic;
      memWait2       : in std_logic;
      nChipEnable1   : out std_logic;
      nChipEnable2   : out std_logic;
      nOutputEnable1 : out std_logic;
      nOutputEnable2 : out std_logic;
      nWriteEnable1  : out std_logic;
      nWriteEnable2  : out std_logic;
      DataBus1       : inout std_logic_vector(15 DOWNTO 0);
      DataBus2       : inout std_logic_vector(15 DOWNTO 0);
      DumpSignal1    : out std_logic;
      DumpSignal2    : out std_logic;
      Address1       : out std_logic_vector(15 DOWNTO 0);
      Address2       : out  std_logic_vector(15 DOWNTO 0)
   );

-- Declarations

END gpu ;

--
-- VHDL Architecture gpu_lib.gpu.struct
--
-- Created:
--          by - mg34.other (srge09.ecn.purdue.edu)
--          at - 00:58:34 04/25/05
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2004.1b (Build 11)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.numeric_std.all;

--LIBRARY gpu_lib;

ARCHITECTURE struct OF gpu IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL Address        : std_logic_vector(15 DOWNTO 0);

   SIGNAL BUSY2          : std_logic;
   SIGNAL BUSY3          : std_logic;
   SIGNAL DATA           : std_logic_vector(47 DOWNTO 0);
   SIGNAL DATA1          : std_logic_vector(95 DOWNTO 0);
   SIGNAL DATA2          : std_logic_vector(511 DOWNTO 0);
   SIGNAL DATA_OUT       : STD_LOGIC_VECTOR(511 DOWNTO 0);
  
   SIGNAL ENABLE         : std_logic;
   SIGNAL LAddress       : std_logic_vector(15 DOWNTO 0);
   SIGNAL LCD_FLIP       : STD_LOGIC;
   SIGNAL LData          : std_logic_vector(15 DOWNTO 0);
   SIGNAL LR_ENABLE      : STD_LOGIC;
   SIGNAL LR_OPCODE      : STD_LOGIC_VECTOR(1 DOWNTO 0);
   SIGNAL Load1          : std_logic;
   SIGNAL MM0_DATA       : STD_LOGIC_VECTOR(511 DOWNTO 0);
   SIGNAL MM0_ENABLE     : STD_LOGIC;
   SIGNAL MM0_OPCODE     : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL MM1_ENABLE     : STD_LOGIC;
   SIGNAL MM1_OPCODE     : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL OPCODE         : std_logic_vector(2 DOWNTO 0);
   SIGNAL OPCODE_OUT     : STD_LOGIC_VECTOR(3 DOWNTO 0);
   SIGNAL RESULT         : std_logic_vector(95 DOWNTO 0);
   SIGNAL RESULT1        : std_logic_vector(23 DOWNTO 0);
   SIGNAL RESULT2        : std_logic_vector(95 DOWNTO 0);
   SIGNAL SB_BUSY        : STD_LOGIC;
   SIGNAL SB_DATA        : STD_LOGIC_VECTOR(23 DOWNTO 0);
   SIGNAL SB_ENABLE      : STD_LOGIC;
   SIGNAL SB_OPCODE      : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL SData          : std_logic_vector(15 DOWNTO 0);
   SIGNAL SDataOut       : std_logic_vector(15 DOWNTO 0);
   SIGNAL SR_READ        : STD_LOGIC;
   SIGNAL Smemwait       : std_logic;
   SIGNAL Store          : std_logic;
   SIGNAL TP0_DATA       : STD_LOGIC_VECTOR(95 DOWNTO 0);
   SIGNAL TP0_OPCODE     : STD_LOGIC_VECTOR(2 DOWNTO 0);
   SIGNAL TP0_RETURN     : STD_LOGIC_VECTOR(23 DOWNTO 0);
   SIGNAL TP1_ENABLE     : STD_LOGIC;
   SIGNAL din0           : std_logic;
   SIGNAL din1           : std_logic;
   SIGNAL din2           : std_logic;
   SIGNAL din3           : std_logic;
   SIGNAL donedraw       : std_logic;
   SIGNAL dout           : std_logic;
   SIGNAL dout1          : std_logic;


   -- Implicit buffer signal declarations
   SIGNAL BUSY_OUT1_internal : STD_LOGIC;


   -- Component Declarations
   COMPONENT LCD_Controller
   PORT (
      LCD_CLK  : IN     STD_LOGIC;
      LData    : IN     std_logic_vector (15 DOWNTO 0);
      nRST     : IN     STD_LOGIC;
      BUSY     : OUT    STD_LOGIC;
      LAddress : OUT    std_logic_vector (15 DOWNTO 0);
      PIXEL    : OUT    STD_LOGIC_VECTOR (7 DOWNTO 0);
      ROW      : OUT    STD_LOGIC
   );
   END COMPONENT;
   COMPONENT Line_Rasterization
   PORT (
      CLK       : IN     std_logic;
      DATA      : IN     std_logic_vector (47 DOWNTO 0);
      ENABLE    : IN     std_logic;
      OPCODE    : IN     std_logic_vector (1 DOWNTO 0);
      SB_BUSY   : IN     std_logic;
      nRST      : IN     std_logic;
      BUSY      : OUT    std_logic;
      RESULT    : OUT    std_logic_vector (23 DOWNTO 0);
      SB_ENABLE : OUT    std_logic
   );
   END COMPONENT;
   COMPONENT SHIFT_REGISTER
   PORT (
      CLK        : IN     STD_LOGIC;
      DATA_IN    : IN     STD_LOGIC_VECTOR (31 DOWNTO 0);
      LOAD       : IN     STD_LOGIC;
      OPCODE_IN  : IN     STD_LOGIC_VECTOR (3 DOWNTO 0);
      READ       : IN     STD_LOGIC;
      nRST       : IN     STD_LOGIC;
      BUSY_OUT   : OUT    STD_LOGIC;
      DATA_OUT   : OUT    STD_LOGIC_VECTOR (511 DOWNTO 0);
      OPCODE_OUT : OUT    STD_LOGIC_VECTOR (3 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT SRAM_Control
   PORT (
      CLK            : IN     std_logic;
      LAddress       : IN     std_logic_vector (15 DOWNTO 0);
      SAddress       : IN     std_logic_vector (15 DOWNTO 0);
      SData          : IN     std_logic_vector (15 DOWNTO 0);
      SLoad          : IN     std_logic;
      SWAP           : IN     std_logic;
      Store          : IN     std_logic;
      donedraw       : IN     std_logic;
      memWait1       : IN     std_logic;
      memWait2       : IN     std_logic;
      nRST           : IN     std_logic;
      Address1       : OUT    std_logic_vector (15 DOWNTO 0);
      Address2       : OUT    std_logic_vector (15 DOWNTO 0);
      BUSY           : OUT    std_logic;
      DumpSignal1    : OUT    std_logic;
      DumpSignal2    : OUT    std_logic;
      LData          : OUT    std_logic_vector (15 DOWNTO 0);
      SDataOut       : OUT    std_logic_vector (15 DOWNTO 0);
      Smemwait       : OUT    std_logic;
      nChipEnable1   : OUT    std_logic;
      nChipEnable2   : OUT    std_logic;
      nOutputEnable1 : OUT    std_logic;
      nOutputEnable2 : OUT    std_logic;
      nWriteEnable1  : OUT    std_logic;
      nWriteEnable2  : OUT    std_logic;
      DataBus1       : INOUT  std_logic_vector (15 DOWNTO 0);
      DataBus2       : INOUT  std_logic_vector (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT TD_Projection
   PORT (
      CLK    : IN     std_logic;
      DATA   : IN     std_logic_vector (95 DOWNTO 0);
      ENABLE : IN     std_logic;
      OPCODE : IN     std_logic_vector (2 DOWNTO 0);
      nRST   : IN     std_logic;
      BUSY   : OUT    std_logic;
      RESULT : OUT    std_logic_vector (23 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT controller
   PORT (
      CLK        : IN     STD_LOGIC;
      DATA       : IN     STD_LOGIC_VECTOR (511 DOWNTO 0);
      ENABLE     : IN     STD_LOGIC;
      LCD_BUSY   : IN     STD_LOGIC;
      LR_BUSY    : IN     STD_LOGIC;
      MM0_RETURN : IN     STD_LOGIC_VECTOR (95 DOWNTO 0);
      MM1_RETURN : IN     STD_LOGIC_VECTOR (95 DOWNTO 0);
      MM_BUSY    : IN     STD_LOGIC;
      OPCODE     : IN     STD_LOGIC_VECTOR (3 DOWNTO 0);
      SB_BUSY    : IN     STD_LOGIC;
      SR_BUSY    : IN     STD_LOGIC;
      TP0_RETURN : IN     STD_LOGIC_VECTOR (23 DOWNTO 0);
      TP1_RETURN : IN     STD_LOGIC_VECTOR (23 DOWNTO 0);
      TP_BUSY    : IN     STD_LOGIC;
      nRST       : IN     STD_LOGIC;
      LCD_FLIP   : OUT    STD_LOGIC;
      LR_DATA    : OUT    STD_LOGIC_VECTOR (47 DOWNTO 0);
      LR_ENABLE  : OUT    STD_LOGIC;
      LR_OPCODE  : OUT    STD_LOGIC_VECTOR (1 DOWNTO 0);
      MM0_DATA   : OUT    STD_LOGIC_VECTOR (511 DOWNTO 0);
      MM0_ENABLE : OUT    STD_LOGIC;
      MM0_OPCODE : OUT    STD_LOGIC_VECTOR (2 DOWNTO 0);
      MM1_DATA   : OUT    STD_LOGIC_VECTOR (511 DOWNTO 0);
      MM1_ENABLE : OUT    STD_LOGIC;
      MM1_OPCODE : OUT    STD_LOGIC_VECTOR (2 DOWNTO 0);
      SB_DATA    : OUT    STD_LOGIC_VECTOR (23 DOWNTO 0);
      SB_ENABLE  : OUT    STD_LOGIC;
      SB_OPCODE  : OUT    STD_LOGIC_VECTOR (2 DOWNTO 0);
      SR_READ    : OUT    STD_LOGIC;
      TP0_DATA   : OUT    STD_LOGIC_VECTOR (95 DOWNTO 0);
      TP0_ENABLE : OUT    STD_LOGIC;
      TP0_OPCODE : OUT    STD_LOGIC_VECTOR (2 DOWNTO 0);
      TP1_DATA   : OUT    STD_LOGIC_VECTOR (95 DOWNTO 0);
      TP1_ENABLE : OUT    STD_LOGIC;
      TP1_OPCODE : OUT    STD_LOGIC_VECTOR (2 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT matrix_math
   PORT (
      CLK    : IN     std_logic;
      DATA   : IN     std_logic_vector (511 DOWNTO 0);
      ENABLE : IN     std_logic;
      OPCODE : IN     std_logic_vector (2 DOWNTO 0);
      RST_N  : IN     std_logic;
      BUSY   : OUT    std_logic;
      RESULT : OUT    std_logic_vector (95 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT screen_buffer
   PORT (
      CLK     : IN     std_logic;
      DATA    : IN     std_logic_vector (23 DOWNTO 0);
      ENABLE  : IN     std_logic;
      OPCODE  : IN     std_logic_vector (2 DOWNTO 0);
      SDataIn : IN     std_logic_vector (15 DOWNTO 0);
      memwait : IN     std_logic;
      nRST    : IN     std_logic;
      Address : OUT    std_logic_vector (15 DOWNTO 0);
      BUSY    : OUT    std_logic;
      Load    : OUT    std_logic;
      SData   : OUT    std_logic_vector (15 DOWNTO 0);
      Store   : OUT    std_logic
   );
   END COMPONENT;
--   COMPONENT sram
--   PORT (
--      Address       : IN     std_logic_vector (15 DOWNTO 0);
--      DumpSignal    : IN     std_logic;
--      nChipEnable   : IN     std_logic;
--      nOutputEnable : IN     std_logic;
--      nWriteEnable  : IN     std_logic;
--      memWait       : OUT    std_logic;
--      DataBus       : INOUT  std_logic_vector (15 DOWNTO 0)
--   );
--   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
--   FOR ALL : LCD_Controller USE ENTITY gpu_lib.LCD_Controller;
--   FOR ALL : Line_Rasterization USE ENTITY gpu_lib.Line_Rasterization;
--   FOR ALL : SHIFT_REGISTER USE ENTITY gpu_lib.SHIFT_REGISTER;
--   FOR ALL : SRAM_Control USE ENTITY gpu_lib.SRAM_Control;
--   FOR ALL : TD_Projection USE ENTITY gpu_lib.TD_Projection;
--   FOR ALL : controller USE ENTITY gpu_lib.controller;
--   FOR ALL : matrix_math USE ENTITY gpu_lib.matrix_math;
--   FOR ALL : screen_buffer USE ENTITY gpu_lib.screen_buffer;
--   FOR ALL : sram USE ENTITY gpu_lib.sram;
   -- pragma synthesis_on


BEGIN

   -- ModuleWare code(v1.5) for instance 'I14' of 'inv'
   busy_out <= NOT(donedraw);

   -- ModuleWare code(v1.5) for instance 'I8' of 'or'
   dout1 <= din0 OR din1;

   -- ModuleWare code(v1.5) for instance 'I15' of 'or'
   dout <= din2 OR din3;

   -- Instance port mappings.
   I12 : LCD_Controller
      PORT MAP (
         LCD_CLK  => LCD_CLK,
         nRST     => nRST,
         LAddress => LAddress,
         LData    => LData,
         BUSY     => donedraw,
         PIXEL    => PIXEL,
         ROW      => ROW
      );
   I6 : Line_Rasterization
      PORT MAP (
         CLK       => CLK,
         nRST      => nRST,
         DATA      => DATA,
         SB_BUSY   => SB_BUSY,
         RESULT    => SB_DATA,
         SB_ENABLE => SB_ENABLE,
         ENABLE    => LR_ENABLE,
         BUSY      => BUSY2,
         OPCODE    => LR_OPCODE
      );
   I13 : SHIFT_REGISTER
      PORT MAP (
         CLK        => CLK,
         LOAD       => LOAD,
         nRST       => nRST,
         OPCODE_IN  => OPCODE_IN,
         OPCODE_OUT => OPCODE_OUT,
         DATA_IN    => DATA_IN,
         DATA_OUT   => DATA_OUT,
         BUSY_OUT   => BUSY_OUT1_internal,
         READ       => SR_READ
      );
   I9 : SRAM_Control
      PORT MAP (
         memwait2       => memwait2,
         CLK            => CLK,
         nRST           => nRST,
         SWAP           => LCD_FLIP,
         BUSY           => BUSY3,
         SAddress       => Address,
         SData          => SData,
         SDataOut       => SDataOut,
         Store          => Store,
         Smemwait       => Smemwait,
         SLoad          => Load1,
         LAddress       => LAddress,
         LData          => LData,
         donedraw       => donedraw,
         nOutputEnable1 => nOutputEnable1,
         nWriteEnable1  => nWriteEnable1,
         nChipEnable1   => nChipEnable1,
         DataBus1       => DataBus1,
         Address1       => Address1,
         DumpSignal1    => DumpSignal1,
         memWait1       => memWait1,
         nOutputEnable2 => nOutputEnable2,
         nWriteEnable2  => nWriteEnable2,
         nChipEnable2   => nChipEnable2,
         DataBus2       => DataBus2,
         Address2       => Address2,
         DumpSignal2    => DumpSignal2
      );
   I1 : TD_Projection
      PORT MAP (
         CLK    => CLK,
         nRST   => nRST,
         DATA   => TP0_DATA,
         RESULT => TP0_RETURN,
         OPCODE => TP0_OPCODE,
         ENABLE => ENABLE,
         BUSY   => din0
      );
   I3 : TD_Projection
      PORT MAP (
         CLK    => CLK,
         nRST   => nRST,
         DATA   => DATA1,
         RESULT => RESULT1,
         OPCODE => OPCODE,
         ENABLE => TP1_ENABLE,
         BUSY   => din1
      );
   I0 : controller
      PORT MAP (
         CLK        => CLK,
         nRST       => nRST,
         ENABLE     => ENABLE1,
         OPCODE     => OPCODE_OUT,
         DATA       => DATA_OUT,
         SR_BUSY    => BUSY_OUT1_internal,
         SR_READ    => SR_READ,
         MM0_ENABLE => MM0_ENABLE,
         MM0_OPCODE => MM0_OPCODE,
         MM0_DATA   => MM0_DATA,
         MM0_RETURN => RESULT2,
         MM1_ENABLE => MM1_ENABLE,
         MM1_OPCODE => MM1_OPCODE,
         MM1_DATA   => DATA2,
         MM1_RETURN => RESULT,
         MM_BUSY    => dout,
         TP0_ENABLE => ENABLE,
         TP0_OPCODE => TP0_OPCODE,
         TP0_DATA   => TP0_DATA,
         TP0_RETURN => TP0_RETURN,
         TP1_ENABLE => TP1_ENABLE,
         TP1_OPCODE => OPCODE,
         TP1_DATA   => DATA1,
         TP1_RETURN => RESULT1,
         TP_BUSY    => dout1,
         LR_ENABLE  => LR_ENABLE,
         LR_OPCODE  => LR_OPCODE,
         LR_DATA    => DATA,
         LR_BUSY    => BUSY2,
         SB_ENABLE  => SB_ENABLE,
         SB_OPCODE  => SB_OPCODE,
         SB_DATA    => SB_DATA,
         SB_BUSY    => SB_BUSY,
         LCD_FLIP   => LCD_FLIP,
         LCD_BUSY   => BUSY3
      );
   I2 : matrix_math
      PORT MAP (
         RESULT => RESULT2,
         CLK    => CLK,
         RST_N  => nRST,
         DATA   => MM0_DATA,
         OPCODE => MM0_OPCODE,
         ENABLE => MM0_ENABLE,
         BUSY   => din2
      );
   I5 : matrix_math
      PORT MAP (
         RESULT => RESULT,
         CLK    => CLK,
         RST_N  => nRST,
         DATA   => DATA2,
         OPCODE => MM1_OPCODE,
         ENABLE => MM1_ENABLE,
         BUSY   => din3
      );
   I4 : screen_buffer
      PORT MAP (
         CLK     => CLK,
         nRST    => nRST,
         DATA    => SB_DATA,
         OPCODE  => SB_OPCODE,
         ENABLE  => SB_ENABLE,
         BUSY    => SB_BUSY,
         Address => Address,
         SData   => SData,
         SDataIn => SDataOut,
         Store   => Store,
         Load    => Load1,
         memwait => Smemwait
      );
--   I10 : sram
--      PORT MAP (
--         nOutputEnable => nOutputEnable1,
--         nWriteEnable  => nWriteEnable1,
--         nChipEnable   => nChipEnable1,
--         DataBus       => DataBus1,
--         Address       => Address1,
--         DumpSignal    => DumpSignal1,
--         memWait       => memWait1
--      );
--   I11 : sram
--      PORT MAP (
--         nOutputEnable => nOutputEnable2,
--         nWriteEnable  => nWriteEnable2,
--         nChipEnable   => nChipEnable2,
--         DataBus       => DataBus2,
--         Address       => Address2,
--         DumpSignal    => DumpSignal2,
--         memWait       => memWait2
--      );

   -- Implicit buffered output assignments
   BUSY_OUT1 <= BUSY_OUT1_internal;

END struct;
