library ieee;
--library gold_lib;   --UNCOMMENT if you're using a GOLD model
use ieee.std_logic_1164.all;
--use gold_lib.all;   --UNCOMMENT if you're using a GOLD model

entity tb_divide_8bit is
end tb_divide_8bit;

architecture TEST of tb_divide_8bit is

  function INT_TO_STD_LOGIC( X: INTEGER; NumBits: INTEGER )
     return STD_LOGIC_VECTOR is
    variable RES : STD_LOGIC_VECTOR(NumBits-1 downto 0);
    variable tmp : INTEGER;
  begin
    tmp := X;
    for i in 0 to NumBits-1 loop
      if (tmp mod 2)=1 then
        res(i) := '1';
      else
        res(i) := '0';
      end if;
      tmp := tmp/2;
    end loop;
    return res;
  end;

  component divide_8bit
    PORT(
         X : in STD_LOGIC_VECTOR(7 downto 0);
         Y : in STD_LOGIC_VECTOR(7 downto 0);
         Z : out STD_LOGIC_VECTOR(14 downto 0)
    );
  end component;

-- Insert signals Declarations here
  signal X : STD_LOGIC_VECTOR(7 downto 0);
  signal Y : STD_LOGIC_VECTOR(7 downto 0);
  signal Z : STD_LOGIC_VECTOR(14 downto 0);

-- signal <name> : <type>;

begin
  DUT: divide_8bit port map(
                X => X,
                Y => Y,
                Z => Z
                );

--   GOLD: <GOLD_NAME> port map(<put mappings here>);

process

  begin

-- Insert TEST BENCH Code Here

    X <= "10101010";
    Y <= "10101010";
    wait for 10 ns;

    X <= "10101010";
    Y <= "01010101";
    wait for 10 ns;

    X <= "00000100";
    Y <= "00000011";
    wait for 10 ns;

    X <= "10101010";
    Y <= "00000000";
    wait for 10 ns;

  end process;
end TEST;