library ieee;
--library gold_lib;   --UNCOMMENT if you're using a GOLD model
use ieee.std_logic_1164.all;
--use gold_lib.all;   --UNCOMMENT if you're using a GOLD model

entity tb_gpu is
generic (Period : Time := 4 ns);
end tb_gpu;

architecture TEST of tb_gpu is

  function INT_TO_STD_LOGIC( X: INTEGER; NumBits: INTEGER )
     return STD_LOGIC_VECTOR is
    variable RES : STD_LOGIC_VECTOR(NumBits-1 downto 0);
    variable tmp : INTEGER;
  begin
    tmp := X;
    for i in 0 to NumBits-1 loop
      if (tmp mod 2)=1 then
        res(i) := '1';
      else
        res(i) := '0';
      end if;
      tmp := tmp/2;
    end loop;
    return res;
  end;

  component gpu
    PORT(
         CLK : IN STD_LOGIC;
         DATA_IN : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
         ENABLE1 : IN STD_LOGIC;
         LCD_CLK : IN STD_LOGIC;
         LOAD : IN STD_LOGIC;
         OPCODE_IN : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
         nRST : IN STD_LOGIC;
         BUSY_OUT1 : OUT STD_LOGIC;
         PIXEL : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
         ROW : OUT STD_LOGIC;
         busy_out : OUT std_logic
    );
  end component;

-- Insert signals Declarations here
  signal CLK : STD_LOGIC;
  signal DATA_IN : STD_LOGIC_VECTOR (31 DOWNTO 0);
  signal ENABLE1 : STD_LOGIC;
  signal LCD_CLK : STD_LOGIC;
  signal LOAD : STD_LOGIC;
  signal OPCODE_IN : STD_LOGIC_VECTOR (3 DOWNTO 0);
  signal nRST : STD_LOGIC;
  signal BUSY_OUT1 : STD_LOGIC;
  signal PIXEL : STD_LOGIC_VECTOR (7 DOWNTO 0);
  signal ROW : STD_LOGIC;
  signal busy_out : std_logic;

-- signal <name> : <type>;

begin

CLKGEN: process
  variable CLK_tmp: std_logic := '0';
begin
  CLK_tmp := not CLK_tmp;
  CLK <= CLK_tmp;
  wait for Period/2;
end process;

  DUT: gpu port map(
                CLK => CLK,
                DATA_IN => DATA_IN,
                ENABLE1 => ENABLE1,
                LCD_CLK => LCD_CLK,
                LOAD => LOAD,
                Load2 => Load2,
                OPCODE_IN => OPCODE_IN,
                nRST => nRST,
                BUSY_OUT1 => BUSY_OUT1,
                Lmemwait => Lmemwait,
                PIXEL => PIXEL,
                ROW => ROW,
                busy_out => busy_out
                );

--   GOLD: <GOLD_NAME> port map(<put mappings here>);
LCD_CLK <= CLK;
process

  begin

-- Insert TEST BENCH Code Here

    ENABLE1 <= '1';


    LOAD <= '0';
    nRST <= '0';
    OPCODE_IN <= "0000";
    DATA_IN <= x"00000000";

    wait for 8 ns;

    nRST <= '1';
    OPCODE_IN <= "0000";
    DATA_IN <= x"FFFFFFFF";
    LOAD <= '0';

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"EEEEEEEE";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"DDDDDDDD";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"CCCCCCCC";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"BBBBBBBB";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"AAAAAAAA";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"99999999";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"88888888";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"77777777";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"66666666";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"55555555";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"44444444";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"33333333";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"22222222";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"11111111";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"00000000";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';
    DATA_IN <= x"FFFFFFFF";

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;
    LOAD <= '0';

    wait for 12 ns;

    wait for 4 ns;

    wait for 4 ns;
    OPCODE_IN <= "0011";
    DATA_IN <= x"ABABABAB";
    LOAD <= '0';

    wait for 4 ns;
    LOAD <= '1';

    wait for 4 ns;

    wait for 1000000 ns;

  end process;
end TEST;