library ieee;
--library gold_lib;   --UNCOMMENT if you're using a GOLD model
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
--use gold_lib.all;   --UNCOMMENT if you're using a GOLD model

entity tb_lcd_controller is
generic (Period : Time := 100 ns);
end tb_lcd_controller;

architecture TEST of tb_lcd_controller is

  function INT_TO_STD_LOGIC( X: INTEGER; NumBits: INTEGER )
     return STD_LOGIC_VECTOR is
    variable RES : STD_LOGIC_VECTOR(NumBits-1 downto 0);
    variable tmp : INTEGER;
  begin
    tmp := X;
    for i in 0 to NumBits-1 loop
      if (tmp mod 2)=1 then
        res(i) := '1';
      else
        res(i) := '0';
      end if;
      tmp := tmp/2;
    end loop;
    return res;
  end;

  component lcd_controller
    PORT(
         LCD_CLK : in STD_LOGIC;
         nRST : in STD_LOGIC;
         LAddress : out std_logic_vector(15 downto 0);
         LData : in std_logic_vector(15 downto 0);
         BUSY : out STD_LOGIC;
         PIXEL : out STD_LOGIC_VECTOR(7 downto 0);
         ROW : out STD_LOGIC
    );
  end component;

-- Insert signals Declarations here
  signal LCD_CLK : STD_LOGIC;
  signal nRST : STD_LOGIC;
  signal LAddress : std_logic_vector(15 downto 0);
  signal LData : std_logic_vector(15 downto 0);
  signal BUSY : STD_LOGIC;
  signal PIXEL : STD_LOGIC_VECTOR(7 downto 0);
  signal ROW : STD_LOGIC;

-- signal <name> : <type>;

begin

CLKGEN: process
  variable LCD_CLK_tmp: std_logic := '0';
begin
  LCD_CLK_tmp := not LCD_CLK_tmp;
  LCD_CLK <= LCD_CLK_tmp;
  wait for Period/2;
end process;

  DUT: lcd_controller port map(
                LCD_CLK => LCD_CLK,
                nRST => nRST,
                LAddress => LAddress,
                LData => LData,
                BUSY => BUSY,
                PIXEL => PIXEL,
                ROW => ROW
                );

--   GOLD: <GOLD_NAME> port map(<put mappings here>);

PIXGEN: process
  variable PIX_tmp : UNSIGNED(7 downto 0) := "00000000";
begin
  PIX_tmp := PIX_tmp + 1;
  LData <= STD_LOGIC_VECTOR(PIX_tmp) & "00000000";
  wait for Period;
end process;

process

  begin

-- Insert TEST BENCH Code Here

    nRST <= '0';
    wait for 125 ns;

    nRST <= '1';
    wait for 1 sec;
  end process;
end TEST;
