library ieee;
--library gold_lib;   --UNCOMMENT if you're using a GOLD model
use ieee.std_logic_1164.all;
--use gold_lib.all;   --UNCOMMENT if you're using a GOLD model

entity tb_matrix_math is
generic (Period : Time := 50 ns);
end tb_matrix_math;

architecture TEST of tb_matrix_math is

  function INT_TO_STD_LOGIC( X: INTEGER; NumBits: INTEGER )
     return STD_LOGIC_VECTOR is
    variable RES : STD_LOGIC_VECTOR(NumBits-1 downto 0);
    variable tmp : INTEGER;
  begin
    tmp := X;
    for i in 0 to NumBits-1 loop
      if (tmp mod 2)=1 then
        res(i) := '1';
      else
        res(i) := '0';
      end if;
      tmp := tmp/2;
    end loop;
    return res;
  end;

  component matrix_math
    PORT(
         RESULT : out std_logic_vector(95 downto 0);
         CLK : in std_logic;
         RST_N : in std_logic;
         DATA : in std_logic_vector(511 downto 0);
         OPCODE : in std_logic_vector(2 downto 0);
         ENABLE : in std_logic;
         BUSY : out std_logic
    );
  end component;

-- Insert signals Declarations here
  signal RESULT : std_logic_vector(95 downto 0);
  signal CLK : std_logic;
  signal RST_N : std_logic;
  signal DATA : std_logic_vector(511 downto 0);
  signal OPCODE : std_logic_vector(2 downto 0);
  signal ENABLE : std_logic;
  signal BUSY : std_logic;

-- signal <name> : <type>;

begin

CLKGEN: process
  variable CLK_tmp: std_logic := '0';
begin
  CLK_tmp := not CLK_tmp;
  CLK <= CLK_tmp;
  wait for Period/2;
end process;

  DUT: matrix_math port map(
                RESULT => RESULT,
                CLK => CLK,
                RST_N => RST_N,
                DATA => DATA,
                OPCODE => OPCODE,
                ENABLE => ENABLE,
                BUSY => BUSY
                );

--   GOLD: <GOLD_NAME> port map(<put mappings here>);

process

  begin

-- Insert TEST BENCH Code Here

    RST_N <= '0';

    DATA <= x"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";

    OPCODE <= "000";

    ENABLE <= '0';

wait for 95 ns;

    RST_N <= '1';
    
wait for 100 ns;

    DATA <= X"00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001";

    OPCODE <= "011"; -- Identity
    
    ENABLE <= '1';

wait for 100 ns;

    DATA <= x"00028000000000000000000000000000000000000002800000000000000000000000000000000000000280000000000000000000000000000000000000028000";
    -- put [2.5 0 0 0, 0 2.5 0 0, 0 0 2.5 0, 0 0 0 2.5] in matrix
    OPCODE <= "010"; -- SetMatrix

wait for 100 ns;
  
    DATA <= x"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000280000002800000028000";
    -- Multiply [2.5 2.5 2.5 0] * Matrix
    OPCODE <= "001"; -- VectorMult

wait for 100 ns;

    --OPCODE <= "000"; -- NOP    
    ENABLE <= '0';

wait for 100 ns;
    
    ENABLE <= '1';
    OPCODE <= "100"; -- MatrixMult

    DATA <= x"00020000000000000000000000000000000000000002000000000000000000000000000000000000000200000000000000000000000000000000000000020000";
    --multiply by 2!
wait for 100 ns;
    
    OPCODE <= "010";
    
    DATA <= x"00028000000000000000000000000000000280000002800000000000000000000002800000000000000280000000000000028000000000000000000000028000";
    -- put [2.5 0.0 0.0 2.5, 
    --      0.0 2.5 0.0 2.5, 
    --      0.0 0.0 2.5 2.5, 
    --      0.0 0.0 0.0 2.5] in matrix


wait for 100 ns;

    OPCODE <= "100"; -- MatrixMult
    DATA <= x"00028000000000000000000000000000000280000002800000000000000000000002800000000000000280000000000000028000000000000000000000028000";
    -- put [2.5 0.0 0.0 2.5, 
    --      0.0 2.5 0.0 2.5, 
    --      0.0 0.0 2.5 2.5, 
    --      0.0 0.0 0.0 2.5] to multiply

    -- result should be:
    --     [6.25 0.0  0.0  12.5, 
    --      0.0  6.25 0.0  12.5, 
    --      0.0  0.0  6.25 12.5, 
    --      0.0  0.0  0.0  6.25]

    
    
wait for 100 ns;
    
    DATA <= x"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000280000002800000028000";
    -- Multiply [2.5 2.5 2.5 1] * Matrix <-- the 1 is not passed in
    OPCODE <= "001"; -- VECTORMULT
    

wait for 100 ns;

    OPCODE <= "000"; -- NOP
    ENABLE <= '0'; --Turn off

wait for 105 ns;    
  end process;
end TEST;