library ieee;

--library gold_lib;   --UNCOMMENT if you're using a GOLD model

use ieee.std_logic_1164.all;

--use gold_lib.all;   --UNCOMMENT if you're using a GOLD model

use ieee.numeric_std.all;



entity tb_signed_divide is

end tb_signed_divide;



architecture TEST of tb_signed_divide is

  constant ZERO: SIGNED(31 downto 0) := "00000000000000000000000000000000";



  function INT_TO_STD_LOGIC( X: INTEGER; NumBits: INTEGER )

     return STD_LOGIC_VECTOR is

    variable RES : STD_LOGIC_VECTOR(NumBits-1 downto 0);

    variable tmp : INTEGER;

  begin

    tmp := X;

    for i in 0 to NumBits-1 loop

      if (tmp mod 2)=1 then

        res(i) := '1';

      else

        res(i) := '0';

      end if;

      tmp := tmp/2;

    end loop;

    return res;

  end;



  component signed_divide

    PORT(

         X : in STD_LOGIC_VECTOR(31 downto 0);

         Y : in STD_LOGIC_VECTOR(31 downto 0);

         Z : out STD_LOGIC_VECTOR(31 downto 0);

         V : out STD_LOGIC

    );

  end component;



-- Insert signals Declarations here

  signal X : STD_LOGIC_VECTOR(31 downto 0);

  signal Y : STD_LOGIC_VECTOR(31 downto 0);

  signal Z : STD_LOGIC_VECTOR(31 downto 0);

  signal V : STD_LOGIC;



  signal nX: STD_LOGIC_VECTOR(31 downto 0);

  signal nY: STD_LOGIC_VECTOR(31 downto 0);

  signal nZ: STD_LOGIC_VECTOR(31 downto 0);



-- signal <name> : <type>;



begin

  DUT: signed_divide port map(

                X => X,

                Y => Y,

                Z => Z,

                V => V

                );



--   GOLD: <GOLD_NAME> port map(<put mappings here>);

  nX <= STD_LOGIC_VECTOR(ZERO - SIGNED(X));

  nY <= STD_LOGIC_VECTOR(ZERO - SIGNED(Y));

  nZ <= STD_LOGIC_VECTOR(ZERO - SIGNED(Z));



process



  begin



-- Insert TEST BENCH Code Here



--                                AAAAAAAAAAAAAAAABBBBBBBBBBBBBBBB

    X <=                         "00000000000000010000000000000000";

    Y <=                         "00000000000000001000000000000000";

    wait for 10 ns;



--                                AAAAAAAAAAAAAAAABBBBBBBBBBBBBBBB

    X <= STD_LOGIC_VECTOR(ZERO - "00000000000000010000000000000000");

    Y <=                         "00000000000000001000000000000000";

    wait for 10 ns;



--                                AAAAAAAAAAAAAAAABBBBBBBBBBBBBBBB

    X <=                         "00000000000000010000000000000000";

    Y <= STD_LOGIC_VECTOR(ZERO - "00000000000000001000000000000000");

    wait for 10 ns;



--                                AAAAAAAAAAAAAAAABBBBBBBBBBBBBBBB

    X <= STD_LOGIC_VECTOR(ZERO - "00000000000000010000000000000000");

    Y <= STD_LOGIC_VECTOR(ZERO - "00000000000000001000000000000000");

    wait for 10 ns;



--                                AAAAAAAAAAAAAAAABBBBBBBBBBBBBBBB

    X <=                         "00000000000100000000000000000000";

    Y <=                         "00000000000000110000000000000000";

    wait for 10 ns;



--                                AAAAAAAAAAAAAAAABBBBBBBBBBBBBBBB

    X <=                         "00000000000100000000000000000000";

    Y <= STD_LOGIC_VECTOR(ZERO - "00000000000000110000000000000000");

    wait for 10 ns;



  end process;

end TEST;