library ieee;
--library gold_lib;   --UNCOMMENT if you're using a GOLD model
use ieee.std_logic_1164.all;
--use gold_lib.all;   --UNCOMMENT if you're using a GOLD model

entity tb_TD_Projection is
generic (Period : Time := 2 ns);
end tb_TD_Projection;

architecture TEST of tb_TD_Projection is

  function INT_TO_STD_LOGIC( X: INTEGER; NumBits: INTEGER )
     return STD_LOGIC_VECTOR is
    variable RES : STD_LOGIC_VECTOR(NumBits-1 downto 0);
    variable tmp : INTEGER;
  begin
    tmp := X;
    for i in 0 to NumBits-1 loop
      if (tmp mod 2)=1 then
        res(i) := '1';
      else
        res(i) := '0';
      end if;
      tmp := tmp/2;
    end loop;
    return res;
  end;

  component TD_Projection
    PORT(
         CLK : in std_logic;
         nRST : in std_logic;
         DATA : in std_logic_vector(95 downto 0);
         RESULT : out std_logic_vector(23 downto 0);
         OPCODE : in std_logic_vector(2 downto 0);
         ENABLE : in std_logic;
         BUSY : out std_logic
    );
  end component;

-- Insert signals Declarations here
  signal CLK : std_logic;
  signal nRST : std_logic;
  signal DATA : std_logic_vector(95 downto 0);
  signal RESULT : std_logic_vector(23 downto 0);
  signal OPCODE : std_logic_vector(2 downto 0);
  signal ENABLE : std_logic;
  signal BUSY : std_logic;

-- signal <name> : <type>;

begin

CLKGEN: process
  variable CLK_tmp: std_logic := '0';
begin
  CLK_tmp := not CLK_tmp;
  CLK <= CLK_tmp;
  wait for Period/2;
end process;

  DUT: TD_Projection port map(
                CLK => CLK,
                nRST => nRST,
                DATA => DATA,
                RESULT => RESULT,
                OPCODE => OPCODE,
                ENABLE => ENABLE,
                BUSY => BUSY
                );

--   GOLD: <GOLD_NAME> port map(<put mappings here>);

process

  begin

-- Insert TEST BENCH Code Here
    DATA   <= x"000000000000000000000000";
    OPCODE <= "000";                   -- nop
    ENABLE <= '0';
    nRST   <= '0';

    wait for 10 ns;
    nRST <= '1';
    OPCODE <= "011";                   -- Set FOVx (1.0) <- no enable!
    DATA <= x"111111111111111100010000";

    wait for 10 ns;
    ENABLE <= '1';                      -- Set FOVx (1.0) <- now enable :-)
    
    wait for 10 ns;
    OPCODE <= "000";                   -- nop
    DATA <= x"110000000000000000010000";

    wait for 10 ns;
    OPCODE <= "100";                   -- Set FOVy (1.0)

    wait for 20 ns;                     -- should get: x=127 y=127 z=2
    OPCODE <= "101";                     -- project
    DATA <= x"010000000100000000020000";  -- x=2.0 y=2.0 z=2.0

    wait for 20 ns;                     -- should get: x=127 y=127 z=32
    OPCODE <= "101";                     -- project
    DATA <= x"020000000200000000200000";  -- x=4.0 y=4.0 z=32.0

    wait for 20 ns;                     -- should get: x=131 y=131 z=2
    OPCODE <= "101";                     -- project
    DATA <= x"080000000800000000020000";  -- x=16.0 y=16.0 z=2.0

    wait for 20 ns;                     -- should get: x=135 y=135 z=1
    OPCODE <= "101";                     -- project
    DATA <= x"080000000800000000010000";  -- x=16.0 y=16.0 z=1.0

    wait for 20 ns;                     -- should get: x=125 y=125 z=1
    OPCODE <= "101";                     -- project
    DATA <= x"FE000000FE00000000010000";  -- x=-4.0 y=-4.0 z=1.0

    wait for 20 ns;                     -- should get: x=125 y=125 z=1
    OPCODE <= "101";                     -- project
    DATA <= x"FC000000FC00000000FF0000";  -- x=-8.0 y=-8.0 z=255.0

    wait for 20 ns;

  end process;
end TEST;
