-- VHDL Entity gpu_lib.gpu.symbol
--
-- Created:
--          by - mg34.other (srge09.ecn.purdue.edu)
--          at - 00:58:34 04/25/05
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2004.1b (Build 11)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY top_level IS
   PORT( 
      CLK       : IN     STD_LOGIC;
      DATA_IN   : IN     STD_LOGIC_VECTOR (31 DOWNTO 0);
      ENABLE1   : IN     STD_LOGIC;
      LCD_CLK   : IN     STD_LOGIC;
      LOAD      : IN     STD_LOGIC;
      OPCODE_IN : IN     STD_LOGIC_VECTOR (3 DOWNTO 0);
      nRST      : IN     STD_LOGIC;
      BUSY_OUT1 : OUT    STD_LOGIC;
      PIXEL     : OUT    STD_LOGIC_VECTOR (7 DOWNTO 0);
      ROW       : OUT    STD_LOGIC;
      busy_out  : OUT    std_logic

   );

-- Declarations

END top_level ;

--
-- VHDL Architecture gpu_lib.gpu.struct
--
-- Created:
--          by - mg34.other (srge09.ecn.purdue.edu)
--          at - 00:58:34 04/25/05
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2004.1b (Build 11)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.numeric_std.all;

--LIBRARY gpu_lib;

ARCHITECTURE struct OF top_level IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL memWait1       : std_logic;
   SIGNAL memWait2       : std_logic;
   SIGNAL nChipEnable1   : std_logic;
   SIGNAL nChipEnable2   : std_logic;
   SIGNAL nOutputEnable1 : std_logic;
   SIGNAL nOutputEnable2 : std_logic;
   SIGNAL nWriteEnable1  : std_logic;
   SIGNAL nWriteEnable2  : std_logic;
   SIGNAL DataBus1 : std_logic_vector(15 downto 0);
   SIGNAL DataBus2 : std_logic_Vector(15 downto 0);
   signal Address1 : std_logic_vector(15 downto 0);
   signal Address2 : std_logic_vector(15 downto 0);
   signal DumpSignal1 : std_logic;
   signal DumpSignal2 : std_logic;

   -- Component Declarations
   COMPONENT GPU
   PORT(
      CLK       : IN     STD_LOGIC;
      DATA_IN   : IN     STD_LOGIC_VECTOR (31 DOWNTO 0);
      ENABLE1   : IN     STD_LOGIC;
      LCD_CLK   : IN     STD_LOGIC;
      LOAD      : IN     STD_LOGIC;
      OPCODE_IN : IN     STD_LOGIC_VECTOR (3 DOWNTO 0);
      nRST      : IN     STD_LOGIC;
      BUSY_OUT1 : OUT    STD_LOGIC;
      PIXEL     : OUT    STD_LOGIC_VECTOR (7 DOWNTO 0);
      ROW       : OUT    STD_LOGIC;
      busy_out  : OUT    std_logic;
      
      memWait1       : in std_logic;
      memWait2       : in std_logic;
      nChipEnable1   : out std_logic;
      nChipEnable2   : out std_logic;
      nOutputEnable1 : out std_logic;
      nOutputEnable2 : out std_logic;
      nWriteEnable1  : out std_logic;
      nWriteEnable2  : out std_logic;
      DataBus1       : inout std_logic_vector(15 DOWNTO 0);
      DataBus2       : inout std_logic_vector(15 DOWNTO 0);
      Address1       : out std_logic_vector(15 DOWNTO 0);
      Address2       : out std_logic_vector(15 DOWNTO 0);
      DumpSignal1    : out std_logic;
      DumpSignal2    : out std_logic
    );
   END COMPONENT;
   
   COMPONENT sram
   PORT (
      Address       : IN     std_logic_vector (15 DOWNTO 0);
      DumpSignal    : IN     std_logic;
      nChipEnable   : IN     std_logic;
      nOutputEnable : IN     std_logic;
      nWriteEnable  : IN     std_logic;
      memWait       : OUT    std_logic;
      DataBus       : INOUT  std_logic_vector (15 DOWNTO 0)
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
--   FOR ALL : LCD_Controller USE ENTITY gpu_lib.LCD_Controller;
--   FOR ALL : Line_Rasterization USE ENTITY gpu_lib.Line_Rasterization;
--   FOR ALL : SHIFT_REGISTER USE ENTITY gpu_lib.SHIFT_REGISTER;
--   FOR ALL : SRAM_Control USE ENTITY gpu_lib.SRAM_Control;
--   FOR ALL : TD_Projection USE ENTITY gpu_lib.TD_Projection;
--   FOR ALL : controller USE ENTITY gpu_lib.controller;
--   FOR ALL : matrix_math USE ENTITY gpu_lib.matrix_math;
--   FOR ALL : screen_buffer USE ENTITY gpu_lib.screen_buffer;
--   FOR ALL : sram USE ENTITY gpu_lib.sram;
   -- pragma synthesis_on


BEGIN
   -- Instance port mappings.
   I_GPU : gpu
     PORT MAP(
       CLK => CLK,
       DATA_IN => DATA_IN,
       ENABLE1 => ENABLE1,
       LCD_CLK => LCD_CLK,
       LOAD => LOAD,
       OPCODE_IN => OPCODE_IN,
       nRST => nRST,
       BUSY_OUT1 => BUSY_OUT1,
       PIXEL => PIXEL,
       ROW => ROW,
       busy_out => busy_out,
               
       memWait1 => memWait1, 
       memWait2 => memWait2,
       nChipEnable1 => nChipEnable1,
       nChipEnable2 => nChipEnable2,
       nOutputEnable1 => nOutputEnable1,
       nOutputEnable2 => nOutputEnable2,
       nWriteEnable1 => nWriteEnable1,
       nWriteEnable2 => nWriteEnable2,
       DataBus1 => DataBus1,
       DataBus2 => DataBus2,
       Address1 => Address1,
       Address2 => Address2,
       DumpSignal1 => DumpSignal1,
       DumpSignal2 => DumpSignal2
     );
   I_SRAM : sram
      PORT MAP (
         nOutputEnable => nOutputEnable1,
         nWriteEnable  => nWriteEnable1,
         nChipEnable   => nChipEnable1,
         DataBus       => DataBus1,
         Address       => Address1,
         DumpSignal    => DumpSignal1,
         memWait       => memWait1
      );
   I_SRAM2 : sram
      PORT MAP (
         nOutputEnable => nOutputEnable2,
         nWriteEnable  => nWriteEnable2,
         nChipEnable   => nChipEnable2,
         DataBus       => DataBus2,
         Address       => Address2,
         DumpSignal    => DumpSignal2,
         memWait       => memWait2
      );

END struct;
