;***********************************************************************
; ECE 362 - Mini-Project - Spring 2004
;
;***********************************************************************
; Concentration game using 8 seven-segment LEDs
; Kevin McCann, Daniel Wilhelm, Andrew Keller
;
;***********************************************************************
;
; Register definitions
;
copctl	equ	$0016	; watchdog timer control register
initrm	equ	$0010	; SRAM location
initrg	equ	$0011	; register map location
initee	equ	$0012	; EEPROM location
eemcr	equ	$00F0	; EEPROM mode control
eeprot	equ	$00F1	; EEPROM protection
feelck	equ	$00F4	; Flash boot block protection
pear	equ	$000A	; PEAR register
misc	equ	$0013	; MISC register
mode	equ	$000B	; MODE register


; General I/O Ports
porta   equ     $0000
ddra    equ     $0002   ; needs to be all set
portb   equ     $0001
ddrb    equ     $0003   ; needs to be all set
portt   equ     $00AE
ddrt    equ     $00AF   ; neets to be all set
portp   equ     $0056
ddrp    equ     $0057   ; needs to be all set


; SCI Registers
sc0bdh	equ	$00C0
sc0bdl	equ	$00C1	; serial communications port - baud rate
sc0cr1	equ	$00C2
sc0cr2	equ	$00C3	; serial communications port - control register

rxdrf    equ   20h    ; receive buffer full mask pattern
txdre    equ   80h    ; transmit buffer empty mask pattern
scisr    equ   00c4h  ; SCI control/status register
scidr    equ   00c7h  ; SCI transmit/receive data register


; Analog-to-Digital Registers (interfaced to potentiometer)
atdctl2 equ	$0062	; ATD control register
atdctl4 equ	0064h	; ATD control register
atdctl5 equ	0065h	; ATD control register
atdstat equ	0067h	; ATD status register (lower byte -- CCF flags)
adr0h	equ	0070h	; ATD Channel 0 result register
adr1h   equ     0072h   ; ATD Channel 1 result register
scfmask equ     $07

; RTI Ports
rtictl	equ	0014h	; real time control register
rtiflg	equ	0015h	; real time flag register
rticlr	equ	80h	; real time interrupt flag bit mask


; Masks
high_nibble_mask equ     $F0    ; to mask out the upper and lower nibble
low_nibble_mask  equ     $0F

potmask	equ	$07
outmask equ     $FF

; ASCII Characters for SCI
NULL    equ     00h
ESC	equ	1bh
RET	equ	0dh
LF	equ	0ah
CR	equ	0dh
BACK	equ	08h


; Interrupt Vector Remapping
undef   equ     $FFFE   ; undefined interrupts cause reset

; Program Constants
numleds   equ      08h


;
; Macro to increment B register modulo %1
;
$macro	incAmod
	inca
	cmpa	#%1
	bne	exit+1
exit	clra
$macroend



;********************************************************************************************
;*************************************BEGINNING OF MEMORY************************************
;********************************************************************************************

        org     $800

LEDA    equ     $800    ; Port A 0-3
LEDB    equ     $801    ; Port A 4-7    ROLLED
LEDC    equ     $802    ; Port B 0-3
LEDD    equ     $803    ; Port B 4-7    ROLLED
LEDE    equ     $804    ; Port P 0-3
LEDF    equ     $805    ; Port P 4-7    ROLLED
LEDG    equ     $806    ; Port T 0-3
LEDH    equ     $807    ; Port T 4-7    ROLLED


Adat    equ     $808    ; Port A 0-3
Bdat    equ     $809    ; Port A 4-7
Cdat    equ     $80A    ; Port B 0-3
Ddat    equ     $80B    ; Port B 4-7
Edat    equ     $80C    ; Port P 0-3
Fdat    equ     $80D    ; Port P 4-7
Gdat    equ     $80E    ; Port T 0-3
Hdat    equ     $80F    ; Port T 4-7

correct equ     $8A0    ; number of correct matches
guess1  equ     $8A1    ; first guess in ASCII format
guess2  equ     $8A2    ; second guess in ASCII format
g1num   equ     $8A3    ; first guess result (number format)
g2num   equ     $8A4    ; second guess result (number format)
time	equ	$8A5    ; Hours
	equ	$8A6	; Minutes
	equ	$8A7	; Seconds

rndnum	equ	$8A8    ; Random number from pots

rticnt	equ	$8AA	; interrupt count



;LEDA    rmb     1       ; Port A 0-3
;LEDB    rmb     1       ; Port A 4-7    ROLLED
;LEDC    rmb     1       ; Port B 0-3
;LEDD    rmb     1       ; Port B 4-7    ROLLED
;LEDE    rmb     1       ; Port P 0-3
;LEDF    rmb     1       ; Port P 4-7    ROLLED
;LEDG    rmb     1       ; Port T 0-3
;LEDH    rmb     1       ; Port T 4-7    ROLLED


;Adat    rmb     1       ; Port A 0-3
;Bdat    rmb     1       ; Port A 4-7
;Cdat    rmb     1       ; Port B 0-3
;Ddat    rmb     1       ; Port B 4-7
;Edat    rmb     1       ; Port P 0-3
;Fdat    rmb     1       ; Port P 4-7
;Gdat    rmb     1       ; Port T 0-3
;Hdat    rmb     1       ; Port T 4-7

;correct fcb     0       ; number of correct matches
;guess1  fcb     0       ; first guess in ASCII format
;guess2  fcb     0       ; second guess in ASCII format
;g1num   fcb     0       ; first guess result (number format)
;g2num   fcb     0       ; second guess result (number format)
;time	fcb	0	; Hours
;	fcb	0	; Minutes
;	fcb	0	; Seconds

;rndnum	rmb	2       ; Random number from pots

;rticnt	fcb	00h	; interrupt count


;
; IMPORTANT NOTE:  Even if you plan to use the "default" values
;                  out of reset for some of the system control
;                  registers, it is a good idea to go ahead
;                  and WRITE the (default) value to it anyway
;                  to prevent software that is in "looney land"
;                  from subsequently changing them.  (Recall
;                  that some of these registers can only be
;                  written to ONCE following reset.)
;
; System startup after reset at location 8000h (beginning of Flash)
;
        org	$8000

start
;
; Disable watchdog timer (COPCTL register)
;
	movb	#$00,copctl	; disable watchdog timer
;
; Make register file start at 0000h (INITRG register)
;
	movb	#$00,initrg	; register file at 0000h
;
; Put into special expanded mode (PEAR register)
;
;	movb	#$2C,pear	; put into special expanded mode
;
; Initialize EEPROM (EEMCR, EEPROT, INITEE registers)
;
	movb	#$fC,eemcr	; lock EEPROM block protect bits
	movb	#$00,eeprot
	movb	#$01,initee	; place EEPROM at 0D00, enable
;
; Initialize Flash (FEELCK register)
;
	movb	#$01,feelck	; protect Flash boot block
;
; Initialize SP to point to top of internal SRAM
;
	lds	#$0C00		; initialize SP at top of SRAM
;
; Change to normal-expanded-narrow mode for zero-wait-state
;            operation (MISC and MODE registers)

	movb	#$03,misc	; FLASH enabled, mapped to 8000-FFFF, no wait states
	;movb	#$29,mode	; change to special expanded narrow mode

        jsr     main
        stop




;********************************************************************************************
;***************************************MAIN CODE in FLASH***********************************
;********************************************************************************************
main
      jsr       init_all

restart
      sei                   ; stop all interrupts
      
      clr       correct
      clr       time
      clr       time+1
      clr       time+2
      
      jsr       set_puz     ; places numbers 1-4 into a-bdat
      jsr       set_LED     ; sets the data to right led data
      jsr       welcome     ; this welcomes the user
      ;jsr       delay       ; delays 3 seconds
      ;jsr       start       ; prompts user to start guessing, and sets clock display - NEEDS TO BE WRITTEN
      cli                   ; starts clock running

      jsr       blankit     ; blanks out all puzzle LEDs
      movb      #$00,correct  ; sets number of correct guesses to 0
guess
     jsr   pmsg         ; Prompt user for guess
     fcb   'First guess: ',NULL

     jsr   inchar       ; 1st Guess
     staa  guess1       ; stores first guess in ASCII format
     jsr   showLED
     ;adda  #$20         ; checks for upper case
     ;jsr   showLED      ; checks for upper case
     staa  g1num        ; stores first guess result (number)

     jsr   pmsg         ; Prompt user for guess
     fcb   "     Second guess: ",NULL

     jsr   inchar       ; 2nd Guess
     staa  guess2       ; stores second guess in ASCII format
     jsr   showLED
     ;adda  #$20         ; checks for upper case
     ;jsr   showLED      ; checks for upper case
     staa  g2num        ; stores 2nd guess result (number)

     jsr   delay        ; waits 3 seconds
     jsr   compare      ; compares g1num and g2num will branch back to guess
     cpx   #1
     beq   ask
     
     ;ldaa  #48t         ; back up to obscure the last guess
     ;jsr   backup

     jsr   pmsg
     fcb   LF,RET,NULL
     bra   guess
     
ask
     ; Prompt whether user wishes to play again
     jsr        pmsg
     fcb        LF,RET,"Play again (y/n)? ",NULL

     jsr        inchar
     jsr        outchar
     jsr        pmsg
     fcb        LF,RET,NULL
     
     cmpa       'y'
     lbeq       restart
     cmpa       'Y'
     lbeq       restart

     rts


;***************************
; compare compares g1num one and g2num
;***************************

compare
     ldx        #0
     ldaa       g1num
     ldab       g2num
     cba
     beq        match   ; goes to correct subroutine, which increases correct and keeps on LED's
     cba
     bne        wrong  ; turns off the LED's pointed to by guess1 and guess2

     ;bra        guess
     rts


;******************************
; Wrong  turns off the LEDS
;***************************
wrong
     ldx        #0
     ldaa       guess1
     jsr        offLED
     ldaa       guess2
     jsr        offLED
     rts



;**************************
; match     increases # correct, and keeps LED's on
;**************************
match
     ldx        #0
     ldaa       correct
     inca
     staa       correct
     cmpa       #$4
     beq        win
     rts


;************************
; diplays winning message and time
; NOTE: Returns 0 if player doesn't want to play again
;       Returns 1 if player wants to play again
;************************
win
     sei        ; stop interrupts

     jsr        pmsg
     fcb        LF,RET,"You correctly guessed all pairs! It only took you ",NULL
     jsr        cdisp
     
     ldx        #1

     rts


;************************
; welcomes the user
;************************
welcome
       jsr      pmsg
       fcb      'Welcome to Memory',LF,RET,NULL
       jsr      pmsg
       fcb      '-----------------',LF,RET,LF,RET,NULL
       jsr      pmsg
       fcb      'Rules: ',LF,RET,NULL
       jsr      pmsg
       fcb      '+ Type a letter (a-h) to indicate which square you want to reveal.',LF,RET,NULL
       jsr      pmsg
       fcb      '+ After two guesses, if the numbers match you got one pair correct.',LF,RET,NULL
       jsr      pmsg
       fcb      '+ When all pairs are correctly guessed, you win!',LF,RET,NULL
       jsr      pmsg
       fcb      '+ HINT: Be as fast as possible for the highest score.',LF,RET,LF,RET,NULL

       rts



;**********************
; blanks the display
;**********************
blankit
       clr      porta
       clr      portb
       clr      portp
       clr      portt
       rts


;**********************
; Initializes the board randomly based on ATD pots
;**********************
set_puz
        movw    $0000,Adat      ; Clear the *dat
        movw    $0000,Cdat
        movw    $0000,Edat
        movw    $0000,Gdat
        
        jsr     inatd           ; Sample the pots

	movb	adr0h,rndnum
	movb	adr1h,rndnum+1

	ldx	#Adat		; Addr of first LED number
	ldab	#8	        ; Number of times to insert number

assign_next
	; mask out all but the lower 3 bits
	ldaa	rndnum+1
	anda	#potmask

	; while (LED not already assigned) test next LED
full    tst     a,x
        beq     assign

	inca                   ; incAmod
	cmpa	#numleds
	bne	cont+1
cont	clra

        bra     full

        ; assign the current number to an empty LED
assign  stab    a,x
        inc     a,x
        asr     a,x         ; divide by 2 so we place 2 of each number

	; rotate the 16-bit random value right 2 times
	ror	rndnum      ; Note that MSB not rotated in correctly
        ror     rndnum+1    ; (doesn't really matter)
        ror     rndnum
        ror     rndnum+1

        dbne    b,assign_next

set_puz_exit
        rts



;**********************
; off LED displays the correct LED
;**********************
offLED
     cmpa  #'a'
     beq   offa
     cmpa  #'b'
     beq   offb
     cmpa  #'c'
     beq   offc
     cmpa  #'d'
     beq   offd
     cmpa  #'e'
     beq   offe
     cmpa  #'f'
     beq   offf
     cmpa  #'g'
     beq   offg
     cmpa  #'h'
     beq   offh
     
offLED_exit
     stab  LEDA 

     rts


;**********************
; ShowLED displays the corrct LED
;**********************
showLED   
     cmpa  #'a'
     lbeq   showa
     cmpa  #'b'
     lbeq   showb
     cmpa  #'c'
     lbeq   showc
     cmpa  #'d'
     lbeq   showd
     cmpa  #'e'
     lbeq   showe
     cmpa  #'f'
     lbeq   showf
     cmpa  #'g'
     lbeq   showg
     cmpa  #'h'
     lbeq   showh

     rts

;*********************************
; The off routines. turns off each LED
;*********************************
offA
     ldaa       porta          ; turns off 0-3 of Port A
     anda       #high_nibble_mask
     staa       porta
     rts

offB
     ldaa       porta          ; turns off 4-7 of Port A
     anda       #low_nibble_mask
     staa       porta
     rts

offC
     ldaa       portb          ; turns off 0-3 of Port B
     anda       #high_nibble_mask
     staa       portb
     rts

offD
     ldaa       portb          ; turns off 4-7 of Port B
     anda       #low_nibble_mask
     staa       portb
     rts

offE
     ldaa       portp          ; turns off 0-3 of Port P
     anda       #high_nibble_mask
     staa       portp
     rts

offF
     ldaa       portp          ; turns off 4-7 of Port P
     anda       #low_nibble_mask
     staa       portp
     rts

offG
     ldaa       portt          ; turns off 0-3 of Port T
     anda       #high_nibble_mask
     staa       portt
     rts

offH
     ldaa       portt          ; turns off 0-3 of Port T
     anda       #low_nibble_mask
     staa       portt
     rts

;*********************************
; The Show routines. turns on each LED
;*********************************
showA
     ldab       porta
     orab       LEDA           ; turns on 0-3 of Port A
     stab       porta
     ldaa       Adat
     rts

showB
     ldab       porta
     orab       LEDB           ; turns on 4-7 of Port A
     stab       porta
     ldaa       Bdat
     rts

showC
     ldab       portb
     orab       LEDC           ; turns on 0-3 of Port B
     stab       portb
     ldaa       Cdat
     rts

showD
     ldab       portb
     orab       LEDD           ; turns on 4-7 of Port B
     stab       portb
     ldaa       Ddat
     rts

showE
     ldab       portp
     orab       LEDE           ; turns on 0-3 of Port P
     stab       portp
     ldaa       Edat
     rts

showF
     ldab       portp
     orab       LEDF           ; turns on 4-7 of Port P
     stab       portp
     ldaa       Fdat
     rts

showG
     ldab       portt
     orab       LEDG           ; turns on 0-3 of Port T
     stab       portt
     ldaa       Gdat
     rts

showH
     ldab       portt
     orab       LEDH           ; turns on 4-7 of Port T
     stab       portt
     ldaa       Hdat
     rts


;*****************************
; Set_LED  will ROL the correct memory for correct display
;*****************************
Set_LED
       movw     Adat,LEDA       ; copy *dat to LED*
       movw     Cdat,LEDC
       movw     Edat,LEDE
       movw     Gdat,LEDG

       asl      LEDB            ; shift odd LEDs to the left one byte
       asl      LEDB            ; (for properly aligned pin transmission)
       asl      LEDB
       asl      LEDB
       
       asl      LEDD
       asl      LEDD
       asl      LEDD
       asl      LEDD

       asl      LEDF
       asl      LEDF
       asl      LEDF
       asl      LEDF

       asl      LEDH
       asl      LEDH
       asl      LEDH
       asl      LEDH

       rts


;******************************
; samples the ATD pots
; *****************************

inatd
        movb    #$10,atdctl5

inatd_await
	brclr	atdstat,scfmask,inatd_await

	rts



;******************************
; delay provides 3 seconds of delay
; *****************************
delay   pshx
        pshy
        pshc
        
        jsr     pmsg
        fcb     'Please wait...',NULL
        
        ldy     #30000t
loopo   ldx     #159t
loopi   nop
        nop
        dbne    x,loopi
        dbne    y,loopo
        
        pulc
        puly
        pulx
        rts


;***************************
;rti_isr counts interrupts until one second lapses
;******************************
rti_isr
	bset	rtiflg,rticlr
	inc	rticnt
	ldaa	rticnt
	cmpa	#122t
	blt	rts_exit
	clr	rticnt
	jsr     clock
        
rts_exit        rti



;**********************************
;Clock increments the clock by one second
;**********************************
clock
	ldy	clock
	ldaa	2,Y
	adda    #01h
	daa
	cmpa	#$60
	beq	upmin
        staa    2,Y
        rts

;**********************************
;Increments the clock by one minute
;**********************************
upmin
     clra
     staa       2,Y
     ldaa       1,Y
     inca
     daa
rts


;*************************************
; Cdisp displays the clock on the screen
;*************************************
cdisp
       ldaa     0,Y
       jsr      pbyte
       jsr      pmsg
       fcb      ":",NULL
       ldaa     1,y
       jsr      pbyte
       jsr      pmsg
       fcb      LF,RET,NULL

       rts
       
;************************
; backs up the number of spaces in B
;***************************
backup
        ldaa    #back
        jsr     outchar
        dbeq    B,exit
        bra     backup



exit   	rts





;***********************************************************************
; Initialization Routines
;***********************************************************************

init_all
        jsr     init_ports
        jsr     blankit
        jsr     init_sci
        jsr     init_rti
        jsr     init_atd
        rts


;*************************
; Init_ports will initialize the output ports to general Output
;************************
init_ports

        movb    #outmask,ddra
        movb    #outmask,ddrb
        movb    #outmask,ddrp
        movb    #outmask,ddrt
        rts


;*************************
; Initialize asynchronous serial port (SCI) for 9600 baud (PROVIDED)
;*************************

init_sci
	movb	#$00,sc0bdh
	movb	#$34,sc0bdl	; set baud rate to 9600
	movb	#$00,sc0cr1
	movb	#$0c,sc0cr2	; initialize SCI
        rts


**************************
; Enable RTI for 8.192 ms interrupt rate
; ;Clear IRQ interrupt mask bit
;**************************
init_rti

	clr	rticnt
	movb	#$84,rtictl
	rts


;**************************
; Enable ATD for program-driven
; Receives 2 pots on Channels 1 and 2
;***************************

init_atd
	; initialize ATD
	movb	#$80,atdctl2
	movb	#01,atdctl4
     	rts




;***********************************************************************
; Character I/O Library Routines for HC12 EVB
;***********************************************************************


;***********************************************************************
; Name:         inchar
; Description:  inputs ASCII character from SCI serial port
;                  and returns it in the A register
; Returns:      ASCII character in A register
; Modifies:     A register
;***********************************************************************

inchar  pshc
cilp    ldaa   #rxdrf ; load receive data register full mask
        bita   scisr  ; check for incoming character
        beq    cilp   ; wait if no character received
        ldaa   scidr  ; return ASCII character in A register
        pulc
        rts


;***********************************************************************
; Subroutine:	pbyte
; Description:	prints (2-digit) hex byte as two ASCII characters
; Input:	hex byte in A accumulator
; Output:	two ASCII characters
; Reg. Mod.:	CC
; Calls:	htoa, outchar
;***********************************************************************

pbyte   psha
        lsra
        lsra
        lsra
        lsra
        jsr     htoa
        jsr     outchar
        ldaa    0,sp
        anda    #$0f
        jsr     htoa
        jsr     outchar
        pula
        rts

;***********************************************************************
; Subroutine:	htoa
; Description:	converts the hex nibble in the A register to ASCII
; Input:	hex nibble in the A accumualtor
; Output:	ASCII character equivalent of hex nibble
; Reg. Mod.:	A, CC
;***********************************************************************

htoa    adda    #$90
        daa
        adca    #$40
        daa
        rts

;***********************************************************************
; pmsg -- Print string following call to routine.  Note that subroutine
;         return address points to string, and is adjusted to point to
;         next valid instruction after call as string is printed.
;***********************************************************************

pmsg    pulx            ; Get pointer to string (return addr).
ploop   ldaa    1,x+    ; Get next character of string.
        beq     pexit   ; Exit if ASCII null encountered.
        jsr     outchar ; Print character on terminal screen.
        bra     ploop   ; Process next string character.
pexit   pshx            ; Place corrected return address on stack.
        rts             ; Exit routine.
;***********************************************************************
; Name:         outchar
; Description:  outputs ASCII character passed in the A register
;                  to the SCI serial port
;***********************************************************************

outchar pshc
        pshb
        ldab   #txdre ; load transmit data register empty mask
colp    bitb   scisr  ; check if ready to transmit
        beq    colp   ; wait if not ready
        staa   scidr  ; output ASCII character to SCI
        pulb
        pulc
        rts
;
;***********************************************************************

;
; Define "where you want to go today" upon reset
;
; NOTE: Other interrupt vectors are added ABOVE this
;       See HC12 Technical Summary document for details
;


        org     $FFFE
        fdb     start   ; point to start of flash

        org $fff0
        fdb rti_isr     ; RTI interrupt

        end
